<?php
/*
Plugin Name: Evonline Admin and Login Theme
Plugin URI: https://www.evonline.com.br/
Description: WordPress Admin Theme - Upload and Activate.
Author: Evonline
Version: 1.0
Author URI: https://www.evonline.com.br/
*/
	
/* Load CSS Files */	
	function admin_toolbar_style() {
		wp_enqueue_style('admin-toolbar-style',	plugins_url() . '/evonline-admin-login-theme/admin/admin-toolbar.css');
	}
	add_action( 'admin_enqueue_scripts', 'admin_toolbar_style' );
	
	function admin_sidebar_style() {
		wp_enqueue_style('admin-sidebar-style',	plugins_url() . '/evonline-admin-login-theme/admin/admin-sidebar.css');
	}
	add_action( 'admin_enqueue_scripts', 'admin_sidebar_style' );
	

	function admin_style() {
		wp_enqueue_style('admin-style',	plugins_url() . '/evonline-admin-login-theme/admin/admin.css');
	}
	add_action( 'admin_enqueue_scripts', 'admin_style' );
	
	function login_style() {
		wp_enqueue_style('login-style',	plugins_url() . '/evonline-admin-login-theme/login/custom-login-styles.css');
	}
	add_action( 'login_enqueue_scripts', 'login_style' );


/* Load Font Awesome */
	function load_font_awesome() { 
		wp_enqueue_script( 'wpb-fa', 'https://kit.fontawesome.com/8bcccb6d26.js' );
	}
	add_action( 'get_footer', 'load_font_awesome' );	

/* Load Icons Evonline */	
	function load_icon_evonline() { 
		wp_enqueue_style('icon-evonline',	plugins_url() . '/evonline-admin-login-theme/style.css');
	}
	add_action( 'get_footer', 'load_icon_evonline' );

/* Remove toolbar when viewing site */	
	add_filter('show_admin_bar', '__return_false');
	
	include_once('login/login-functions.php');
	include_once('admin/admin-functions.php');

/* Add a custom user role 
	$result = add_role( 'estrategico', __(
	'Estratégico' ),
	array( ) );	*/		

	function _remove_script_version( $src ){
		$parts = explode( '?ver', $src );
		return $parts[0];
	}
	add_filter( 'script_loader_src', '_remove_script_version', 15, 1 );
	add_filter( 'style_loader_src', '_remove_script_version', 15, 1 );