<?php
/**
 * The Header
 *
 * This is the template that displays all of the <head> section and everything up until
 * <div id="mk-theme-container">.
 *
 * @package Jupiter
 */

?>
<!DOCTYPE html>
<html <?php language_attributes(); ?> >
<?php do_action( 'mk_theme_before_head' ); ?>
<script src="https://www.googleoptimize.com/optimize.js?id=OPT-KDJ95LD"></script> <head>
	
	
	<!-- Meta Pixel Code -->
<script>
!function(f,b,e,v,n,t,s)
{if(f.fbq)return;n=f.fbq=function(){n.callMethod?
n.callMethod.apply(n,arguments):n.queue.push(arguments)};
if(!f._fbq)f._fbq=n;n.push=n;n.loaded=!0;n.version='2.0';
n.queue=[];t=b.createElement(e);t.async=!0;
t.src=v;s=b.getElementsByTagName(e)[0];
s.parentNode.insertBefore(t,s)}(window, document,'script',
'https://connect.facebook.net/en_US/fbevents.js');
fbq('init', '1524079994789685');
fbq('track', 'PageView');
</script>
<noscript><img height="1" width="1" style="display:none"
src="https://www.facebook.com/tr?id=1524079994789685&ev=PageView&noscript=1"
/></noscript>
<!-- End Meta Pixel Code -->
	
	
	
	
	<!-- Google Tag Manager -->
<script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
})(window,document,'script','dataLayer','GTM-MXV4V8W');</script>
<!-- End Google Tag Manager -->
	
	
	<?php do_action( 'mk_theme_after_head_opening' ); ?>
	<?php wp_head(); ?>
	<?php do_action( 'mk_theme_before_head_closing' ); ?>
</head>

<body <?php body_class( mk_get_body_class( global_get_post_id() ) ); ?> <?php echo get_schema_markup( 'body' ); // WPCS: XSS OK. ?> data-adminbar="<?php echo esc_attr( is_admin_bar_showing() ); ?>">
	
	<!-- Google Tag Manager (noscript) -->
<noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-MXV4V8W"
height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
<!-- End Google Tag Manager (noscript) -->
	
	
	<?php
		if ( function_exists( 'wp_body_open' ) ) {
			wp_body_open();
		}

		do_action( 'mk_theme_after_body_opening' );

		// Hook when you need to add content right after body opening tag. to be used in child themes or customisations.
		do_action( 'theme_after_body_tag_start' );
	?>

	<!-- Target for scroll anchors to achieve native browser bahaviour + possible enhancements like smooth scrolling -->
	<div id="top-of-page"></div>

		<div id="mk-boxed-layout">

			<div id="mk-theme-container" <?php echo is_header_transparent( 'class="trans-header"' ); ?>>

				<?php
				mk_get_header_view( 'styles', 'header-' . get_header_style() );
